
  macro dQ_damping_Gauss(Qdamp,Qdampv)                                                             ' Gaussian dampening due to the instrumental resolution dQ
{
	'Models dampening of the PDF intensity as a function of r due to a constant width reciprocal space peak shape
	'Ref: Acta Cryst. (1992). A48, 336-346
	#m_argu Qdamp 'Instrumental FWHM of S(Q) data/2.34
	If_Prm_Eqn_Rpt(Qdamp,Qdampv, min 0.001 max 3, del 0.0001)
	scale_phase_X =  Exp(-0.5 X^2 (CeV(Qdamp,Qdampv))^2);                          'Gaussian dampening 
}
 	 
	 
	 
  macro dQ_damping_Lor(Qdamp2,Qdampv2)                                                             ' Gaussian dampening due to the instrumental resolution dQ
{
	'Models dampening of the PDF intensity as a function of r due to a constant width reciprocal space peak shape
	'Ref: Acta Cryst. (1992). A48, 336-346
	#m_argu Qdamp2 'Instrumental FWHM of S(Q) data/2.34
	'If_Prm_Eqn_Rpt(Qdamp,Qdampv, min 0.001 max 0.3, del 0.0001)
	If_Prm_Eqn_Rpt(Qdamp2,Qdampv2, min 0.001 max 3, del 0.0001)
	scale_phase_X = Exp(- 0.5 X (CeV(Qdamp2,Qdampv2))); '*Cos(2*Pi*X*Q2)*Cos(2*Pi*X*Q3)*Cos(2*Pi*X*Q4)*Cos(2*Pi*X*Q5)*Cos(2*Pi*X*Q6)*Cos(2*Pi*X*Q7)) ;                          'Gaussian dampening 
}
 	 
macro broad_Gauss(deltaG, deltaGv)
{
 #m_argu deltaG
 If_Prm_Eqn_Rpt(deltaG, deltaGv, min 0.00001 max 1 del 0.0001)

 local #m_unique fwhm = CeV(deltaG,deltaGv) Xo;

 pdf_convolute = 2 Sqrt(Ln(2)/Pi)*Exp(-4*Ln(2)/fwhm^2 X^2);
 min_X = Min(-3*fwhm, 0) ;
 max_X = Max(3*fwhm, 0) ;
 convolute_X_recal = If(Xo,1,1) 1;
} 	 
	  
	 
macro broad_Lor(deltaL, deltaLv)
{
 #m_argu deltaL
 If_Prm_Eqn_Rpt(deltaL, deltaLv, min 0.000001 max 1 del 0.0001)

 local #m_unique fwhm = CeV(deltaL, deltaLv)*(Xo);

 pdf_convolute =  fwhm/2/Pi/(X^2 + fwhm^2/4);
 min_X = Min(-10*fwhm, 0);
 max_X = Max(10*fwhm, 0);
 convolute_X_recal = If(Xo,1,1) 1;
}


macro Beqpdffit(c, v)	                                                                 ' Defining PDFgui type r-dependent beq values 	
   {
		#m_argu c
      If_Prm_Eqn_Rpt(c, v, min 1e-6 max 5 val_on_continue = Val Rand(.1, 2); )
      beq = CeV(c, v) (1- Min((delt1/X + delt2/X^2 - Qb^2 X^2),1)) ;

   }

  
  macro dQ_damping_G(Qdamp,Qdampv)                                                             ' Gaussian dampening due to the instrumental resolution dQ
{
	'Models dampening of the PDF intensity as a function of r due to a constant width reciprocal space peak shape
	'Ref: Acta Cryst. (1992). A48, 336-346
	#m_argu Qdamp 'Instrumental FWHM of S(Q) data/2.34
	If_Prm_Eqn_Rpt(Qdamp,Qdampv, min 0.001 max 0.2, del 0.0001)
	scale_phase_X = Exp(-0.5  X^2 (CeV(Qdamp,Qdampv))^2);                          'Gaussian dampening 
}
macro convolute_Qmax_Sinc_2(Qmax,Qmaxv)                                                ' Fourier ripples due to the limited Qmax
{
	'Convolution to include Sinc function due to termeination of S(Q) at finite Qmax during Fourier transform
	'Use in combination with start_X 1 to avoid very low-r data 
	'Ref: J. S. Chung and M. F. Thorpe, Phys. Rev. B, 55(3), 1997, 1545
	#m_argu Qmax 'maximum Q used for Fourier transform 
	If_Prm_Eqn_Rpt(Qmax, Qmaxv, min 1 max 100, del 0.01)
	local #m_unique conv_max = (5 CeV(Qmax,Qmaxv) - Mod(5 CeV(Qmax,Qmaxv),1))/5 2 Pi / CeV(Qmax,Qmaxv);
	pdf_convolute = If(Abs(X) > Yobs_dx_at(Xo),(Sin(CeV(Qmax,Qmaxv) X)/(X)),CeV(Qmax,Qmaxv));
		min_X = Min(-Xo,-conv_max) ;
		max_X = Max( Xo, conv_max) ;
}